/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.montoyo.wd.client.gui.GuiKeyboard;
import net.montoyo.wd.client.gui.GuiServer;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.controls.Container;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.server_bound.C2SMessageACQuery;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Bounds;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Vector3i;

public abstract class WDScreen
extends Screen {
    public static WDScreen CURRENT_SCREEN = null;
    protected final ArrayList<Control> controls = new ArrayList();
    protected final ArrayList<Control> postDrawList = new ArrayList();
    private final HashMap<Class<? extends Event>, Method> eventMap = new HashMap();
    protected boolean quitOnEscape = true;
    protected boolean defaultBackground = true;
    protected int syncTicks = 40;
    private int syncTicksLeft = -1;

    public WDScreen(Component component) {
        super(component);
        Method[] methods;
        for (Method m : methods = ((Object)((Object)this)).getClass().getMethods()) {
            if (m.getAnnotation(GuiSubscribe.class) == null) continue;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new RuntimeException("Found non public @GuiSubscribe");
            }
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1 || !Event.class.isAssignableFrom(params[0])) {
                throw new RuntimeException("Invalid parameters for @GuiSubscribe");
            }
            this.eventMap.put(params[0], m);
        }
    }

    protected <T extends Control> T addControl(T ctrl) {
        this.controls.add(ctrl);
        return ctrl;
    }

    public int screen2DisplayX(int x) {
        double ret = (double)x / (double)this.f_96543_ * (double)this.f_96541_.m_91268_().m_85441_();
        return (int)ret;
    }

    public int screen2DisplayY(int y) {
        double ret = (double)y / (double)this.f_96544_ * (double)this.f_96541_.m_91268_().m_85442_();
        return (int)ret;
    }

    public int display2ScreenX(int x) {
        double ret = (double)x / (double)this.f_96541_.m_91268_().m_85441_() * (double)this.f_96543_;
        return (int)ret;
    }

    public int display2ScreenY(int y) {
        double ret = (double)y / (double)this.f_96541_.m_91268_().m_85442_() * (double)this.f_96544_;
        return (int)ret;
    }

    protected void centerControls() {
        Bounds bounds = Control.findBounds(this.controls);
        int diffX = (this.f_96543_ - bounds.maxX - bounds.minX) / 2;
        int diffY = (this.f_96544_ - bounds.maxY - bounds.minY) / 2;
        for (Control ctrl : this.controls) {
            int x = ctrl.getX();
            int y = ctrl.getY();
            ctrl.setPos(x + diffX, y + diffY);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float ptt) {
        if (this.defaultBackground) {
            this.m_7333_(poseStack);
        }
        for (Control ctrl : this.controls) {
            ctrl.draw(poseStack, mouseX, mouseY, ptt);
        }
        for (Control ctrl : this.postDrawList) {
            ctrl.postDraw(poseStack, mouseX, mouseY, ptt);
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean typed = false;
        for (Control ctrl : this.controls) {
            typed = typed || ctrl.keyTyped(codePoint, modifiers);
        }
        return typed;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Control ctrl;
        boolean clicked = false;
        Iterator<Control> iterator = this.controls.iterator();
        while (iterator.hasNext() && !(clicked = (ctrl = iterator.next()).mouseClicked(mouseX, mouseY, button))) {
        }
        return clicked;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean mouseReleased = false;
        for (Control ctrl : this.controls) {
            mouseReleased = mouseReleased || ctrl.mouseReleased(mouseX, mouseY, button);
        }
        return mouseReleased;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean dragged = false;
        for (Control ctrl : this.controls) {
            dragged = dragged || ctrl.mouseClickMove(mouseX, mouseY, button, dragX, dragX);
        }
        return dragged;
    }

    protected void m_7856_() {
        CURRENT_SCREEN = this;
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public void m_7379_() {
        if (this.syncTicksLeft >= 0) {
            this.sync();
            this.syncTicksLeft = -1;
        }
        for (Control ctrl : this.controls) {
            ctrl.destroy();
        }
        Minecraft.m_91087_().f_91068_.m_90926_(false);
        CURRENT_SCREEN = null;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean scrolled = false;
        for (Control ctrl : this.controls) {
            scrolled = scrolled || ctrl.mouseScroll(mouseX, mouseY, delta);
        }
        return scrolled;
    }

    public void m_94757_(double mouseX, double mouseY) {
        boolean moved = false;
        for (Control ctrl : this.controls) {
            moved = moved || ctrl.mouseMove(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean down = false;
        for (Control ctrl : this.controls) {
            down = down || ctrl.keyDown(keyCode, scanCode, modifiers);
        }
        if (this instanceof GuiKeyboard) {
            return down;
        }
        return new GuiServer(new Vector3i(), new NameUUIDPair()).m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        boolean up = false;
        for (Control ctrl : this.controls) {
            up = up || ctrl.keyUp(keyCode, scanCode, modifiers);
        }
        return up || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public Object actionPerformed(Event ev) {
        Method m = this.eventMap.get(ev.getClass());
        if (m != null) {
            try {
                return m.invoke((Object)this, ev);
            }
            catch (IllegalAccessException e) {
                Log.errorEx("Access to event %s of screen %s is denied", e, ev.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName());
            }
            catch (InvocationTargetException e) {
                Log.errorEx("Event %s of screen %s failed", e, ev.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName());
            }
        }
        return null;
    }

    public <T extends Control> T getControlByName(String name) {
        for (Control ctrl : this.controls) {
            Control ret;
            if (name.equals(ctrl.getName())) {
                return (T)ctrl;
            }
            if (!(ctrl instanceof Container) || (ret = ((Container)ctrl).getByName(name)) == null) continue;
            return (T)ret;
        }
        return null;
    }

    protected void addLoadCustomVariables(Map<String, Double> vars) {
    }

    public void loadFrom(ResourceLocation resLoc) {
        try {
            Field[] fields;
            JsonObject root = GuiLoader.getJson(resLoc);
            if (root == null) {
                throw new RuntimeException("Could not load GUI file " + resLoc.toString());
            }
            if (!root.has("controls") || !root.get("controls").isJsonArray()) {
                throw new RuntimeException("In GUI file " + resLoc.toString() + ": missing root 'controls' object.");
            }
            HashMap<String, Double> vars = new HashMap<String, Double>();
            vars.put("width", Double.valueOf(this.f_96543_));
            vars.put("height", Double.valueOf(this.f_96544_));
            vars.put("displayWidth", Double.valueOf(this.f_96541_.m_91268_().m_85441_()));
            vars.put("displayHeight", Double.valueOf(this.f_96541_.m_91268_().m_85442_()));
            this.addLoadCustomVariables(vars);
            JsonArray content = root.get("controls").getAsJsonArray();
            for (JsonElement elem : content) {
                this.controls.add(GuiLoader.create(new JsonOWrapper(elem.getAsJsonObject(), vars)));
            }
            for (Field f : fields = ((Object)((Object)this)).getClass().getDeclaredFields()) {
                f.setAccessible(true);
                FillControl fc = f.getAnnotation(FillControl.class);
                if (fc == null) continue;
                String name = fc.name().isEmpty() ? f.getName() : fc.name();
                Object ctrl = this.getControlByName(name);
                if (ctrl == null) {
                    if (!fc.required()) continue;
                    throw new RuntimeException("In GUI file " + resLoc.toString() + ": missing required control " + name);
                }
                if (!f.getType().isAssignableFrom(ctrl.getClass())) {
                    throw new RuntimeException("In GUI file " + resLoc.toString() + ": invalid type for control " + name);
                }
                try {
                    f.set((Object)this, ctrl);
                }
                catch (IllegalAccessException e) {
                    if (!fc.required()) continue;
                    throw new RuntimeException(e);
                }
            }
            if (root.has("center") && root.get("center").getAsBoolean()) {
                this.centerControls();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        for (Control ctrl : this.controls) {
            ctrl.destroy();
        }
        this.controls.clear();
        super.m_6574_(minecraft, width, height);
    }

    protected void requestAutocomplete(String beginning, boolean matchExact) {
        WDNetworkRegistry.INSTANCE.sendToServer((Object)new C2SMessageACQuery(beginning, matchExact));
    }

    public void onAutocompleteResult(NameUUIDPair[] pairs) {
    }

    public void onAutocompleteFailure() {
    }

    protected void requestSync() {
        this.syncTicksLeft = this.syncTicks - 1;
    }

    protected boolean syncRequested() {
        return this.syncTicksLeft >= 0;
    }

    protected void abortSync() {
        this.syncTicksLeft = -1;
    }

    protected void sync() {
    }

    public void m_86600_() {
        if (this.syncTicksLeft >= 0 && --this.syncTicksLeft < 0) {
            this.sync();
        }
    }

    public void drawItemStackTooltip(PoseStack poseStack, ItemStack is, int x, int y) {
        this.m_6057_(poseStack, is, x, y);
    }

    public void drawTooltip(PoseStack poseStack, List<String> lines, int x, int y) {
        this.renderTooltip(poseStack, lines.stream().map(a -> FormattedCharSequence.m_13714_((String)a, (Style)Style.f_131099_)).collect(Collectors.toList()), x, y, this.f_96547_);
    }

    public void requirePostDraw(Control ctrl) {
        if (!this.postDrawList.contains(ctrl)) {
            this.postDrawList.add(ctrl);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public abstract boolean isForBlock(BlockPos var1, BlockSide var2);

    @Nullable
    public String getWikiPageName() {
        return null;
    }
}

